/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5434;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_8917;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class ModifiedStructurePoolBasedGenerator {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, class_6880<class_3785> structurePool, Optional<class_2960> id, int size, class_2338 pos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, class_8891 aliasLookup, class_9778 dimensionPadding, class_9822 liquidSettings) {
        class_2338 blockPos;
        class_5455 dynamicRegistryManager = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_2919 chunkRandom = context.comp_566();
        class_2378 registry = dynamicRegistryManager.method_30530(class_7924.field_41249);
        class_2470 blockRotation = class_2470.field_11467;
        class_3785 structurePool2 = structurePool.method_40230().flatMap(key -> registry.method_31189(aliasLookup.lookup(key))).orElse((class_3785)structurePool.comp_349());
        class_3784 structurePoolElement = structurePool2.method_16631((class_5819)chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            class_2960 identifier = id.get();
            Optional<class_2338> optional = ModifiedStructurePoolBasedGenerator.findStartingJigsawPos(structurePoolElement, identifier, pos, blockRotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.method_19308(), blockRotation, structurePoolElement.method_16628(structureTemplateManager, blockPos2, blockRotation), liquidSettings);
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = projectStartToHeightmap.isPresent() ? pos.method_10264() + chunkGenerator.method_20402(i, j, projectStartToHeightmap.get(), heightLimitView, context.comp_564()) : blockPos2.method_10264();
        int bX = Math.abs(blockBox.method_35414() / 2);
        int bZ = Math.abs(blockBox.method_14663() / 2);
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(-bX, k - l, -bZ);
        int m = k + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                class_238 box = new class_238((double)(i - maxDistanceFromCenter), (double)Math.max(m - maxDistanceFromCenter, heightLimitView.method_31607() + dimensionPadding.comp_2818()), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)Math.min(m + maxDistanceFromCenter + 1, heightLimitView.method_31600() - dimensionPadding.comp_2819()), (double)(j + maxDistanceFromCenter + 1));
                class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
                ModifiedStructurePoolBasedGenerator.generate(context.comp_564(), size, useExpansionHack, chunkGenerator, structureTemplateManager, heightLimitView, (class_5819)chunkRandom, (class_2378<class_3785>)registry, poolStructurePiece, list, voxelShape, aliasLookup, liquidSettings);
                Objects.requireNonNull(collector);
                list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
            }
        }));
    }

    private static Optional<class_2338> findStartingJigsawPos(class_3784 pool, class_2960 id, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_2919 random) {
        List list = pool.method_16627(structureManager, pos, rotation, (class_5819)random);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 identifier = class_2960.method_12829((String)Objects.requireNonNull(structureBlockInfo.comp_1343(), () -> String.valueOf(structureBlockInfo) + " nbt was null").method_10558("name"));
            if (!id.equals((Object)identifier)) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    private static void generate(class_7138 noiseConfig, int maxSize, boolean modifyBoundingBox, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, class_265 pieceShape, class_8891 aliasLookup, class_9822 liquidSettings) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.generatePiece(firstPiece, (MutableObject<class_265>)new MutableObject((Object)pieceShape), 0, modifyBoundingBox, heightLimitView, noiseConfig, aliasLookup, liquidSettings);
        while (structurePoolGenerator.structurePieces.hasNext()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = (ShapedPoolStructurePiece)structurePoolGenerator.structurePieces.next();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, modifyBoundingBox, heightLimitView, noiseConfig, aliasLookup, liquidSettings);
        }
    }

    public static boolean generate(class_3218 world, class_6880<class_3785> structurePool, class_2960 id, int size, class_2338 pos, boolean keepJigsaws) {
        class_2794 chunkGenerator = world.method_14178().method_12129();
        class_3485 structureTemplateManager = world.method_14183();
        class_5138 structureAccessor = world.method_27056();
        class_5819 random = world.method_8409();
        class_3195.class_7149 context = new class_3195.class_7149(world.method_30349(), chunkGenerator, chunkGenerator.method_12098(), world.method_14178().method_41248(), structureTemplateManager, world.method_8412(), new class_1923(pos), (class_5539)world, biome -> true);
        Optional<class_3195.class_7150> optional = ModifiedStructurePoolBasedGenerator.generate(context, structurePool, Optional.of(id), size, pos, false, Optional.empty(), 128, class_8891.field_46826, class_5434.field_51911, class_5434.field_52235);
        if (optional.isPresent()) {
            class_6626 structurePiecesCollector = optional.get().method_44019();
            for (class_3443 structurePiece : structurePiecesCollector.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                poolStructurePiece.method_27236((class_5281)world, structureAccessor, chunkGenerator, random, class_3341.method_14665(), pos, keepJigsaws);
            }
            return true;
        }
        return false;
    }

    static final class StructurePoolGenerator {
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> children;
        private final class_5819 random;
        final class_8917<ShapedPoolStructurePiece> structurePieces = new class_8917();

        StructurePoolGenerator(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.children = children;
            this.random = random;
        }

        void generatePiece(class_3790 piece, MutableObject<class_265> pieceShape, int minY, boolean modifyBoundingBox, class_5539 world, class_7138 noiseConfig, class_8891 aliasLookup, class_9822 liquidSettings) {
            class_3784 structurePoolElement = piece.method_16644();
            class_2338 blockPos = piece.method_16648();
            class_2470 blockRotation = class_2470.field_11467;
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            boolean bl = projection == class_3785.class_3786.field_16687;
            MutableObject<class_265> mutableObject = new MutableObject<class_265>();
            class_3341 blockBox = piece.method_14935();
            int i = blockBox.method_35416();
            block0: for (class_3499.class_3501 structureBlockInfo : structurePoolElement.method_16627(this.structureTemplateManager, blockPos, blockRotation, this.random)) {
                class_3784 structurePoolElement2;
                MutableObject<class_265> mutableObject2;
                class_2350 direction = class_3748.method_26378((class_2680)structureBlockInfo.comp_1342());
                class_2338 blockPos2 = structureBlockInfo.comp_1341();
                class_2338 blockPos3 = blockPos2.method_10093(direction);
                int j = blockPos2.method_10264() - i;
                int k = -1;
                class_5321<class_3785> registryKey = StructurePoolGenerator.lookupPool(structureBlockInfo, aliasLookup);
                Optional optional = this.registry.method_40264(registryKey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.method_29177());
                    continue;
                }
                class_6880 registryEntry = (class_6880)optional.get();
                if (((class_3785)registryEntry.comp_349()).method_16632() == 0 && !registryEntry.method_40225(class_5468.field_26254)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.method_29177());
                    continue;
                }
                class_6880 registryEntry2 = ((class_3785)registryEntry.comp_349()).method_46736();
                if (((class_3785)registryEntry2.comp_349()).method_16632() == 0 && !registryEntry2.method_40225(class_5468.field_26254)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)registryEntry2.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = blockBox.method_14662((class_2382)blockPos3);
                if (bl2) {
                    mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)));
                    }
                } else {
                    mutableObject2 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.maxSize) {
                    list.addAll(((class_3785)registryEntry.comp_349()).method_16633(this.random));
                }
                list.addAll(((class_3785)registryEntry2.comp_349()).method_16633(this.random));
                int l = structureBlockInfo.comp_1343() != null ? structureBlockInfo.comp_1343().method_10550("placement_priority") : 0;
                Iterator var32 = list.iterator();
                while (var32.hasNext() && (structurePoolElement2 = (class_3784)var32.next()) != class_3777.field_16663) {
                    for (class_2470 blockRotation2 : class_2470.method_16547((class_5819)this.random)) {
                        List list2 = structurePoolElement2.method_16627(this.structureTemplateManager, class_2338.field_10980, blockRotation2, this.random);
                        class_3341 blockBox2 = structurePoolElement2.method_16628(this.structureTemplateManager, class_2338.field_10980, blockRotation2);
                        int m = modifyBoundingBox && blockBox2.method_14660() <= 16 ? list2.stream().mapToInt(structureBlockInfox -> {
                            if (!blockBox2.method_14662((class_2382)structureBlockInfox.comp_1341().method_10093(class_3748.method_26378((class_2680)structureBlockInfox.comp_1342())))) {
                                return 0;
                            }
                            class_5321<class_3785> registryKey2 = StructurePoolGenerator.lookupPool(structureBlockInfox, aliasLookup);
                            Optional optional3 = this.registry.method_40264(registryKey2);
                            Optional<class_6880> optional2 = optional3.map(entry -> ((class_3785)entry.comp_349()).method_46736());
                            int o = optional3.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            int p = optional2.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            return Math.max(i, j);
                        }).max().orElse(0) : 0;
                        for (class_3499.class_3501 structureBlockInfo2 : list2) {
                            int u;
                            int s;
                            int q;
                            if (!class_3748.method_16546((class_3499.class_3501)structureBlockInfo, (class_3499.class_3501)structureBlockInfo2)) continue;
                            class_2338 blockPos4 = structureBlockInfo2.comp_1341();
                            class_2338 blockPos5 = blockPos3.method_10059((class_2382)blockPos4);
                            class_3341 blockBox3 = structurePoolElement2.method_16628(this.structureTemplateManager, blockPos5, blockRotation2);
                            int n = blockBox3.method_35416();
                            class_3785.class_3786 projection2 = structurePoolElement2.method_16624();
                            boolean bl3 = projection2 == class_3785.class_3786.field_16687;
                            int o = blockPos4.method_10264();
                            int p = j - o + class_3748.method_26378((class_2680)structureBlockInfo.comp_1342()).method_10164();
                            if (bl && bl3) {
                                q = i + p;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                }
                                q = k - o;
                            }
                            int r = q - n;
                            class_3341 blockBox4 = blockBox3.method_19311(0, r, 0);
                            class_2338 blockPos6 = blockPos5.method_10069(0, r, 0);
                            if (m > 0) {
                                s = Math.max(m + 1, blockBox4.method_35419() - blockBox4.method_35416());
                                blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + s, blockBox4.method_35417()));
                            }
                            if (class_259.method_1074((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                            mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                            s = piece.method_16646();
                            int t = bl3 ? s - p : structurePoolElement2.method_19308();
                            class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, structurePoolElement2, blockPos6, t, blockRotation2, blockBox4, liquidSettings);
                            if (bl) {
                                u = i + j;
                            } else if (bl3) {
                                u = q + o;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                }
                                u = k + p / 2;
                            }
                            piece.method_16647(new class_3780(blockPos3.method_10263(), u - j + s, blockPos3.method_10260(), p, projection2));
                            poolStructurePiece.method_16647(new class_3780(blockPos2.method_10263(), u - o + t, blockPos2.method_10260(), -p, projection));
                            this.children.add((class_3790)poolStructurePiece);
                            if (minY + 1 > this.maxSize) continue block0;
                            ShapedPoolStructurePiece shapedPoolStructurePiece = new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, minY + 1);
                            this.structurePieces.method_54726((Object)shapedPoolStructurePiece, l);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static class_5321<class_3785> lookupPool(class_3499.class_3501 structureBlockInfo, class_8891 aliasLookup) {
            class_2487 nbtCompound = Objects.requireNonNull(structureBlockInfo.comp_1343(), () -> String.valueOf(structureBlockInfo) + " nbt was null");
            class_5321 registryKey = class_5468.method_60923((String)nbtCompound.method_10558("pool"));
            return aliasLookup.lookup(registryKey);
        }
    }

    private static final class ShapedPoolStructurePiece {
        final class_3790 piece;
        final MutableObject<class_265> pieceShape;
        final int currentSize;

        ShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize) {
            this.piece = piece;
            this.pieceShape = pieceShape;
            this.currentSize = currentSize;
        }
    }
}

